<?php
/**
 * WATCHLATER.PHP - Cyber-themed Gateway Redirector
 * Applied Gateway Routing while maintaining original variables.
 */

// Define a constant to ensure files are loaded correctly.
define('IS_MAIN', true);

// Redirect all traffic to HTTPS for security.
if (empty($_SERVER['HTTPS']) || $_SERVER['HTTPS'] === 'off') {
    header('Location: https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
    exit;
}

// ==== ESSENTIAL INCLUDES ====
require_once('access.php');
include('geo_filter.php');
include('block.php');
include('histats.php');
include('ads2.php');

// Define the current URL.
$current_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];

/** * SYSTEM UPDATE: 
 * Routing via Link Manager using original $watchlater variable.
 */
$gateway_target = $link_manager . "?id=" . $watchlater;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="<?php echo $meta_description; ?>">
    
    <meta http-equiv="refresh" content="3;url=<?php echo $gateway_target; ?>">

    <title>Redirecting to secure page...</title>

    <meta property="og:title" content="<?php echo $meta_title; ?>">
    <meta property="og:description" content="<?php echo $meta_description; ?>">
    <meta property="og:image" content="<?php echo $meta_image; ?>">
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo "https://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>">

    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo $meta_title; ?>">
    <meta name="twitter:description" content="<?php echo $meta_description; ?>">
    <meta name="twitter:image" content="<?php echo $meta_image; ?>">

    <link rel="icon" href="<?php echo $meta_logo; ?>" type="image/png">

    <style>
        body {
            margin: 0; padding: 0;
            font-family: 'Courier New', monospace;
            background-color: #000; color: #0ff;
            overflow: hidden;
        }

        .container {
            position: absolute; top: 50%; left: 50%;
            transform: translate(-50%, -50%);
            text-align: center; background: rgba(0, 0, 0, 0.5);
            padding: 40px; border-radius: 15px;
            box-shadow: 0 0 20px #0ff;
        }

        .loading-text {
            font-size: 32px; font-weight: bold;
            color: #0ff; text-shadow: 0 0 10px #0ff, 0 0 20px #0ff;
            animation: shimmer 2s infinite;
        }

        @keyframes shimmer {
            0% { text-shadow: 0 0 10px #0ff; }
            50% { text-shadow: 0 0 30px #0ff; }
            100% { text-shadow: 0 0 10px #0ff; }
        }

        .dot-flash::after {
            content: ''; display: inline-block;
            width: 8px; height: 8px;
            background-color: #0ff; border-radius: 50%;
            animation: blink 1s infinite; margin-left: 8px;
        }

        @keyframes blink { 0%, 100% { opacity: 1; } 50% { opacity: 0; } }

        .progress-bar {
            width: 100%; background: rgba(0, 255, 255, 0.1);
            height: 10px; border-radius: 5px;
            overflow: hidden; margin-top: 20px;
        }

        .progress-bar-fill {
            height: 100%; width: 0%;
            background: linear-gradient(90deg, #0ff, #08f);
            animation: fill 3s forwards;
        }

        @keyframes fill { 0% { width: 0%; } 100% { width: 100%; } }

        .typed-info {
            font-size: 26px; color: #0ff;
            text-shadow: 0 0 5px #0ff; margin-top: 30px;
            white-space: pre-wrap; min-height: 28px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="loading-text">Please wait<span class="dot-flash"></span></div>
        <div class="progress-bar">
            <div class="progress-bar-fill"></div>
        </div>
        <div class="typed-info" id="typedText"></div>
    </div>

    <script>
        const textToType = "Redirecting ...\nYou will be connected shortly.";
        const typedTextEl = document.getElementById("typedText");

        function typeExtraText(text, i = 0) {
            if (i < text.length) {
                typedTextEl.textContent += text.charAt(i);
                setTimeout(() => typeExtraText(text, i + 1), 50);
            }
        }

        window.addEventListener("load", () => {
            typeExtraText(textToType);
        });
    </script>
</body>
</html>