<?php
/**
 * CONTINUE.PHP - Intermediate Gateway Landing Page
 * Applied Gateway Routing while maintaining original variables.
 */
define('IS_MAIN', true);

// Redirect to HTTPS if not already using it
if (empty($_SERVER['HTTPS']) || $_SERVER['HTTPS'] === 'off') {
    header('Location: https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
    exit;
}

// ==== IMPORTANT INCLUDES  ====
require_once('access.php');
include('geo_filter.php');

$current_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
?>
<!DOCTYPE html>
<html>
<head>
    <title>Redirecting to Secure Page</title>

    <meta http-equiv="refresh" content="3;url=<?php echo $link_manager . '?id=' . $continue; ?>">
    
    <meta name="description" content="<?php echo $meta_description;?>"/>
    <meta property="og:image:alt" content="<?php echo $meta_description;?>"/>
    <meta name="twitter:card" content="summary_large_image"/>
    <meta name="twitter:description" content="<?php echo $meta_description;?>"/>
    <meta name="twitter:title" content="<?php echo $meta_title;?>">
    <meta name="twitter:site" content="<?php echo $url_web;?>" />
    <meta name="twitter:url" content="<?php echo $url_web;?>" />
    <meta itemprop="image" content="<?php echo $meta_img;?>" />
    <meta name="twitter:image" content="<?php echo $meta_img;?>" />

    <link rel="icon" type="image/png" href="<?php echo $shortcut;?>" />
    <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.min.css">
    
    <style>
        body { background:#000; }
        #load { 
            position:absolute;width:600px;height:36px;left:50%;top:40%;margin-left:-300px;
            overflow:visible;user-select:none;cursor:default;
        }
        #load div { 
            position:absolute;width:20px;height:36px;opacity:0;font-family:Helvetica,Arial,sans-serif;
            animation:move 2s linear infinite; transform:rotate(180deg); color:#35c4f0;
        }
        #load div:nth-child(2){animation-delay:.2s}
        #load div:nth-child(3){animation-delay:.4s}
        #load div:nth-child(4){animation-delay:.6s}
        #load div:nth-child(5){animation-delay:.8s}
        #load div:nth-child(6){animation-delay:1s}
        #load div:nth-child(7){animation-delay:1.2s}

        @keyframes move {
            0% {left:0;opacity:0}
            35% {left:41%;transform:rotate(0);opacity:1}
            65% {left:59%;transform:rotate(0);opacity:1}
            100% {left:100%;transform:rotate(-180deg);opacity:0}
        }
    </style>
</head>
<body>
    <?php
    // Include necessary modules.
    include('ads2.php');
    include('tracker.php');
    include('block.php');
    ?>

    <div id="load" class="centered">
        <div>G</div><div>N</div><div>I</div><div>D</div><div>A</div><div>O</div><div>L</div>
    </div>
    
    <script type='text/javascript'>
        var _Hasync=_Hasync|| [];
        _Hasync.push(['Histats.start', '1,<?php echo $id_histats;?>,4,0,0,0,00010000']);
        _Hasync.push(['Histats.fasi', '1']);
        _Hasync.push(['Histats.track_hits', '']);
        (function(){
            var hs=document.createElement('script'); hs.type='text/javascript'; hs.async=true;
            hs.src=('https://s10.histats.com/js15_as.js');
            (document.getElementsByTagName('head')[0] || document.getElementsByTagName('body')[0]).appendChild(hs);
        })();
    </script>
    <noscript>
        <a href='https://www.histats.com' target='_blank'>
            <img src='https://sstatic1.histats.com/0.gif?<?php echo $id_histats;?>&101' alt='web stats' border='0'>
        </a>
    </noscript>
</body>
</html>